require "prefabutil"

chestfunctions = require("scenarios/chestfunctions")

local assets=
{
	Asset("ANIM", "anim/ee_chest.zip"),
	Asset("ANIM", "anim/ui_chest_3x2.zip"),
	--Asset("ANIM", "anim/skull_chest.zip"),
	
	
	--   Asset("ANIM", "anim/ee_chest.zip"),
	
	Asset("IMAGE", "images/eechest.tex"),
	Asset("ATLAS", "images/eechest.xml"),
}

local chests = {
	ee_chest = {
		bank="chest",
		build="ee_chest",
	},
}

local function CreatingItem(inst, itemname)
	if inst.EEupgraded then
		local items = {{item = itemname,count = 1,},}
		chestfunctions.AddChestItems(inst, items)
	else
		inst.components.lootdropper:SpawnLootPrefab(itemname)
	end
end

local function DoIdle(inst)
	inst.components.EMCglobalbuffer:AddToGlobal(300000)
	if inst.EEhasWork == true then
		local fquit = false
		while fquit == false do
			if inst.components.container.numslots and inst.EEfexchange <= inst.components.container.numslots then
			
				local k = inst.EEfexchange
				
				local item = inst.components.container:GetItemInSlot(k)
				if item then
					if inst.EEglobalUpgraded then  --Global Singularity
						if inst.components.EMCglobalbuffer.EMC == 0 then
							if item.EMCvalue then
								local itemcount = 1
								if item.components.stackable then
									itemcount = item.components.stackable.stacksize
								end
								inst.components.EMCglobalbuffer.EMC = ((itemcount) * item.EMCvalue)
								item = inst.components.container:RemoveItemBySlot(k)
								item:Remove()
								fquit = true
								
							end
						else
							inst.EEfexchange = inst.EEfexchange-1
							fquit = true
						end
					else
						if item.EMCvalue and ( not item.EMCname or item.EMCname ~= "goldnugget") then
							local itemcount = 1
							if item.components.stackable then
								itemcount = item.components.stackable.stacksize
							end
							inst.components.EMCintern.EMC = inst.components.EMCintern.EMC + ((itemcount) * item.EMCvalue)
							item = inst.components.container:RemoveItemBySlot(k)
							item:Remove()
							fquit = true
							
							local fgoAnimation = false
							while inst.components.EMCintern.EMC >= 3000 do
								inst.components.EMCintern.EMC = inst.components.EMCintern.EMC - 3000
								CreatingItem(inst, "goldnugget")
								fgoAnimation = true
							end
							if fgoAnimation == true then
								--ChattyNode(inst, STRINGS.PIG_TALK_FOLLOWWILSON)
								inst.AnimState:PlayAnimation("open") 
								inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
								inst:DoTaskInTime(0.5, function()
									inst.AnimState:PlayAnimation("close") 
									inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
								end)
							end
						end
					end
				end
			else
				inst.EEhasWork = false
				fquit = true
			end
			inst.EEfexchange = inst.EEfexchange + 1
		end
	end
end

local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
	inst.EEhasWork = false
end

local function StartIdling(inst)
	inst.EEhasWork = true
	inst.EEfexchange = 1
	
	--See if upgrading
	if inst.EEupgraded == false then
		local EEgoldslots = 0
		local EEgoldnuggetsinslots = 0
		for fA = 1,inst.components.container.numslots do
			local item = inst.components.container:GetItemInSlot(fA)
			if item and item.EMCname and item.EMCname == "goldnugget" then
				EEgoldslots = EEgoldslots + 1
				EEgoldnuggetsinslots = EEgoldnuggetsinslots + item.components.stackable.stacksize
			end
		end
		--print("EEgoldslots: "..EEgoldslots.."  EEgoldnuggetsinslots: "..EEgoldnuggetsinslots)
		if EEgoldslots >= inst.components.container.numslots then
			inst.EEupgraded = true
			for fA = 1,inst.components.container.numslots do
				local item = inst.components.container:RemoveItemBySlot(fA)
				--item:Remove()
			end
			for fA = 1,EEgoldnuggetsinslots-inst.components.container.numslots do
				CreatingItem(inst, "goldnugget")
			end
		end
	end
	if inst.EEglobalUpgraded == false then
		for fA = 1,inst.components.container.numslots do
			if inst.EEglobalUpgraded == false then
				local item = inst.components.container:GetItemInSlot(fA)
				if item and item.EMCname and item.EMCname == "globalsingularity" then
					local singularityleft = item.components.stackable.stacksize-1
					inst.components.EMCglobalbuffer.EMC = 20*3000
					inst.EEglobalUpgraded = true
					inst.components.container:RemoveItemBySlot(fA)
					item:Remove()
					for fB = 1,singularityleft do
						CreatingItem(inst, "globalsingularity")
					end
				end
			end
		end
	end
	
	if not inst.idletask then
		inst.idletask = inst:DoPeriodicTask(2.5, DoIdle)
	end
end

local function onopen(inst)
	StopIdling(inst)
	inst.AnimState:PlayAnimation("open") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("close") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
	StartIdling(inst)
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed", false)
end

local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end



local function OnSave(inst, data)
    if inst.EEupgraded and inst.EEupgraded == true then
        data["EEUpGr"] = "yes"
    end
	if inst.EEglobalUpgraded and inst.EEglobalUpgraded == true then
        data["EEGlUpGr"] = "yes"
    end
end

local function OnLoad(inst, data)
	if not data then
		return
	end
    if data["EEUpGr"] then
		--print("EEUpGr:"..data["EEUpGr"])
		inst.EEupgraded = true
	else
		print("no EEupgraded")
		inst.EEupgraded = false
	end
	if data["EEGlUpGr"] then
		--print("EEUpGr:"..data["EEUpGr"])
		inst.EEglobalUpgraded = true
	else
		print("no EEglobalUpgraded")
		inst.EEglobalUpgraded = false
	end
end
		
local function chest(style)
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )


		inst:AddTag("structure")
		inst.AnimState:SetBank(chests[style].bank)
		inst.AnimState:SetBuild(chests[style].build)
		--inst.AnimState:SetBuild("treasure_chest")
		inst.AnimState:PlayAnimation("closed")
		
		inst:AddComponent("inspectable")
		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_chest_3x3"
		inst.components.container.widgetanimbuild = "ui_chest_3x3"
		inst.components.container.widgetpos = Vector3(0,200,0)
		inst.components.container.side_align_tip = 160
		
		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(2)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)
		
		local light = inst.entity:AddLight()
		light:SetIntensity(0.3)
		light:SetRadius(2)
		light:SetColour(1/255, 1/255, 255/255)
		light:Enable(true)
		
		inst.EEupgraded = false
		inst.EEglobalUpgraded = false
		
		inst:AddComponent("EMCglobalbuffer")
		--inst.components.EMCglobalbuffer.maxEMC = 0
		inst:AddComponent("EMCintern")
		StartIdling(inst)
		
		
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
	
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/eechest", chest("ee_chest"), assets),
		MakePlacer("common/prefab/eechest_placer", "chest", "ee_chest", "closed")

